<?php
ini_set('display_errors', 1);
error_reporting(E_ALL); // Mostrar todos los errores
include(__DIR__ . '/../includes/functions.php');

// Decodificar y procesar los datos de entrada
$infos = explode("{}", base64_decode($_GET['info']));
$dnsId = $infos[0];
$username = $infos[1];
$password = $infos[2];
$macAddressFull = strtoupper(base64_decode($infos[3]));

// Procesar MAC (formato XX:XX:XX:XX)
$macHexOnly = str_replace(':', '', $macAddressFull);
$macShortHex = substr($macHexOnly, 0, 8);
$macAddress = implode(':', str_split($macShortHex, 2));

// Generar nombre de cliente con hash único
$hash = strtoupper(substr(md5(uniqid(rand(), true)), 0, 4));
$cliente_nombre = 'Cliente' . $hash; // Ejemplo: ClienteB4E1

// Generar fecha de expiración (formato YYYY-MM-DD)
$expiracion = date('Y-m-d', strtotime('+1 year')); // Asegurar formato válido

// Verificar si el registro existe
$result = $db->select('playlist', '*', 'dns_id = :dns_id AND mac_address = :mac_address', '', [
    ':dns_id' => $dnsId,
    ':mac_address' => $macAddress
]);

if (!empty($result)) {
    // Actualizar registro existente
    $data = [
        'username' => $username,
        'password' => $password,
        'pin' => '0000',
        'cliente_nombre' => $cliente_nombre, // Asegurar que no sea NULL
        'expiracion' => $expiracion, // Formato YYYY-MM-DD
    ];
    $db->update('playlist', $data, 'dns_id = :dns_id AND mac_address = :mac_address', [
        ':dns_id' => $dnsId,
        ':mac_address' => $macAddress
    ]);
} else {
    // Insertar nuevo registro
    $data = [
        'dns_id' => $dnsId,
        'mac_address' => $macAddress,
        'username' => $username,
        'password' => $password,
        'pin' => '0000',
        'cliente_nombre' => $cliente_nombre, // Asegurar que no sea NULL
        'expiracion' => $expiracion, // Formato YYYY-MM-DD
    ];
    $db->insert('playlist', $data);
}

$response = ['success' => 1, 'id' => $dnsId, "name" => null, "url" => null];
echo json_encode($response);