<?php
// Configuración
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__.'/php_errors.log');

session_start();

// Función de conexión
function connectSQLite($path) {
    try {
        $db = new SQLite3($path);
        $db->enableExceptions(true);
        $db->busyTimeout(5000);
        return $db;
    } catch (Exception $e) {
        error_log("Error de conexión: ".$e->getMessage());
        return false;
    }
}

// Conexiones
$db = connectSQLite(__DIR__.'/api/.db.db');
$codesDB = connectSQLite(__DIR__.'/api/codes_rgvip.db');

if (!$db || !$codesDB) {
    die("<div class='alert alert-danger'>Error al conectar con las bases de datos</div>");
}

// Token CSRF
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Procesamiento
$mensaje = '';
$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['csrf_token'], $_POST['code'])) {
    if (!hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        die("<div class='alert alert-danger'>Token inválido</div>");
    }

    $code = trim($_POST['code']);
    
    if (empty($code) || !preg_match('/^[A-Z0-9]{6,20}$/', $code)) {
        $mensaje = "❌ Código inválido";
    } else {
        try {
            // 1. Buscar código
            $stmt = $codesDB->prepare("SELECT * FROM activation_codes WHERE code = ? AND used = 0 LIMIT 1");
            $stmt->bindValue(1, $code, SQLITE3_TEXT);
            $data = $stmt->execute()->fetchArray(SQLITE3_ASSOC);
            
            if ($data) {
                // 2. Insertar en playlist (incluyendo el pin parental 0000)
                $stmt = $db->prepare("INSERT INTO playlist 
    (mac_address, username, password, expiracion, dns_id, cliente_nombre, pin, cliente_whatsapp, is_protected) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");

$stmt->bindValue(1, strtoupper($data['mac_address']), SQLITE3_TEXT);
$stmt->bindValue(2, $data['username'], SQLITE3_TEXT);
$stmt->bindValue(3, $data['password'], SQLITE3_TEXT);
$stmt->bindValue(4, $data['expiracion'], SQLITE3_TEXT);
$stmt->bindValue(5, $data['dns_id'], SQLITE3_INTEGER);
$stmt->bindValue(6, $data['cliente_nombre'] ?? 'Cliente', SQLITE3_TEXT);
$stmt->bindValue(7, '0000', SQLITE3_TEXT); // PIN parental fijo
$stmt->bindValue(8, $data['cliente_whatsapp'] ?? '', SQLITE3_TEXT);
$stmt->bindValue(9, $data['is_protected'] ?? 0, SQLITE3_INTEGER);
                
                if ($stmt->execute()) {
                    // 3. Insertar en subscription (si existe)
                    try {
                        $stmt = $db->prepare("INSERT INTO subscription 
                            (mac_address, username, password, exp_date, status) 
                            VALUES (?, ?, ?, ?, 'active')");
                        
                        $stmt->bindValue(1, strtoupper($data['mac_address']), SQLITE3_TEXT);
                        $stmt->bindValue(2, $data['username'], SQLITE3_TEXT);
                        $stmt->bindValue(3, $data['password'], SQLITE3_TEXT);
                        $stmt->bindValue(4, $data['expiracion'], SQLITE3_TEXT);
                        $stmt->execute();
                    } catch (Exception $e) {
                        error_log("Info: No se insertó en subscription - ".$e->getMessage());
                    }
                    
                    // 4. Marcar como usado
                    $codesDB->exec("UPDATE activation_codes SET used = 1 WHERE code = '".SQLite3::escapeString($code)."'");
                    
                    $mensaje = "✅ Activación exitosa para MAC: ".htmlspecialchars($data['mac_address']);
                    $success = true;
                } else {
                    throw new Exception("Error al insertar: ".$db->lastErrorMsg());
                }
            } else {
                $mensaje = "❌ Código no válido o ya usado";
            }
        } catch (Exception $e) {
            $mensaje = "❌ Error: ".htmlspecialchars($e->getMessage());
            error_log("Error en activación: ".$e->getMessage());
        }
    }
}
include 'includes/header.php';
?>
<div class="col-md-6 mx-auto">
    <div class="card shadow mb-4">
    <div class="card bg-dark text-white">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Activación de Servicio</h6>
        </div>
        <div class="card-body">
            <?php if ($mensaje): ?>
                <div class="alert <?= $success ? 'alert-success' : 'alert-danger' ?>">
                    <?= $mensaje ?>
                </div>
            <?php endif; ?>
            <form method="post">
                <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token']) ?>">
                <div class="form-group">
                    <label>Código de Activación</label>
                    <input type="text" name="code" class="form-control" required 
                           placeholder="Ej: ABC123DEF456" pattern="[A-Z0-9]{6,20}">
                </div>
                <button type="submit" class="btn btn-primary btn-block">Activar</button>
            </form>
        </div>
    </div>
</div>
<script>
// Convertir a mayúsculas automáticamente
document.querySelector("input[name='code']").addEventListener('input', function(e) {
    this.value = this.value.toUpperCase();
});
</script>
<?php
$db->close();
$codesDB->close();
include 'includes/footer.php';